include:
  - util.syncstates
  - .packages_{{ grains['machine_id'] }}

{%- if grains['os_family'] == 'Suse' and grains['instance_id'] is defined and "openSUSE" not in grains['oscodename'] %}
{# install flavor check tool in cloud instances to be able to detect payg instances #}
mgr_install_flavor_check:
  pkg.installed:
    - name: python-instance-billing-flavor-check
    - require:
      - file: mgrchannels_*
{%- if grains.get('__suse_reserved_saltutil_states_support', False) %}
      - saltutil: sync_states
{%- else %}
      - mgrcompat: sync_states
{%- endif %}

{%- if grains['os_family'] == 'RedHat' and grains['osmajorrelease'] < 8 %}
  pkg.installed:
    - name: yum-utils
    - require:
      - file: mgrchannels_*
      - mgrcompat: sync_states
{%- endif %}

mgr_refresh_grains:
{%- if grains.get('__suse_reserved_saltutil_states_support', False) %}
  saltutil.sync_grains:
{%- else %}
  mgrcompat.module_run:
    - name: saltutil.sync_grains
{%- endif %}
    - reload_grains: true
    - onchanges:
      - pkg: mgr_install_flavor_check
{%- endif %}
